<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Fax\V1\Fax;

use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class FaxMediaContext extends InstanceContext {
    /**
     * Initialize the FaxMediaContext
     * 
     * @param Version $version Version that contains the resource
     * @param string $faxSid Fax SID
     * @param string $sid A string that uniquely identifies this fax media
     * @return FaxMediaContext
     */
    public function __construct(Version $version, $faxSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('faxSid' => $faxSid, 'sid' => $sid, );

        $this->uri = '/Faxes/' . rawurlencode($faxSid) . '/Media/' . rawurlencode($sid) . '';
    }

    /**
     * Fetch a FaxMediaInstance
     * 
     * @return FaxMediaInstance Fetched FaxMediaInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        $params = Values::of(array());

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new FaxMediaInstance(
            $this->version,
            $payload,
            $this->solution['faxSid'],
            $this->solution['sid']
        );
    }

    /**
     * Deletes the FaxMediaInstance
     * 
     * @return boolean True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete() {
        return $this->version->delete('delete', $this->uri);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Fax.V1.FaxMediaContext ' . implode(' ', $context) . ']';
    }
}