<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Api\V2010;
use Twilio\Rest\Api\V2010\Account\AddressContext;
use Twilio\Rest\Api\V2010\Account\AddressList;
use Twilio\Rest\Api\V2010\Account\ApplicationContext;
use Twilio\Rest\Api\V2010\Account\ApplicationList;
use Twilio\Rest\Api\V2010\Account\AuthorizedConnectAppContext;
use Twilio\Rest\Api\V2010\Account\AuthorizedConnectAppList;
use Twilio\Rest\Api\V2010\Account\AvailablePhoneNumberCountryContext;
use Twilio\Rest\Api\V2010\Account\AvailablePhoneNumberCountryList;
use Twilio\Rest\Api\V2010\Account\BalanceList;
use Twilio\Rest\Api\V2010\Account\CallContext;
use Twilio\Rest\Api\V2010\Account\CallList;
use Twilio\Rest\Api\V2010\Account\ConferenceContext;
use Twilio\Rest\Api\V2010\Account\ConferenceList;
use Twilio\Rest\Api\V2010\Account\ConnectAppContext;
use Twilio\Rest\Api\V2010\Account\ConnectAppList;
use Twilio\Rest\Api\V2010\Account\IncomingPhoneNumberContext;
use Twilio\Rest\Api\V2010\Account\IncomingPhoneNumberList;
use Twilio\Rest\Api\V2010\Account\KeyContext;
use Twilio\Rest\Api\V2010\Account\KeyList;
use Twilio\Rest\Api\V2010\Account\MessageContext;
use Twilio\Rest\Api\V2010\Account\MessageList;
use Twilio\Rest\Api\V2010\Account\NewKeyList;
use Twilio\Rest\Api\V2010\Account\NewSigningKeyList;
use Twilio\Rest\Api\V2010\Account\NotificationContext;
use Twilio\Rest\Api\V2010\Account\NotificationList;
use Twilio\Rest\Api\V2010\Account\OutgoingCallerIdContext;
use Twilio\Rest\Api\V2010\Account\OutgoingCallerIdList;
use Twilio\Rest\Api\V2010\Account\QueueContext;
use Twilio\Rest\Api\V2010\Account\QueueList;
use Twilio\Rest\Api\V2010\Account\RecordingContext;
use Twilio\Rest\Api\V2010\Account\RecordingList;
use Twilio\Rest\Api\V2010\Account\ShortCodeContext;
use Twilio\Rest\Api\V2010\Account\ShortCodeList;
use Twilio\Rest\Api\V2010\Account\SigningKeyContext;
use Twilio\Rest\Api\V2010\Account\SigningKeyList;
use Twilio\Rest\Api\V2010\Account\SipList;
use Twilio\Rest\Api\V2010\Account\TokenList;
use Twilio\Rest\Api\V2010\Account\TranscriptionContext;
use Twilio\Rest\Api\V2010\Account\TranscriptionList;
use Twilio\Rest\Api\V2010\Account\UsageList;
use Twilio\Rest\Api\V2010\Account\ValidationRequestList;
use Twilio\Rest\Api\V2010\AccountContext;
use Twilio\Rest\Api\V2010\AccountList;
use Twilio\Version;

/**
 * @property V2010 v2010
 * @property AccountList accounts
 * @property AccountContext account
 * @property AddressList addresses
 * @property ApplicationList applications
 * @property AuthorizedConnectAppList authorizedConnectApps
 * @property AvailablePhoneNumberCountryList availablePhoneNumbers
 * @property BalanceList balance
 * @property CallList calls
 * @property ConferenceList conferences
 * @property ConnectAppList connectApps
 * @property IncomingPhoneNumberList incomingPhoneNumbers
 * @property KeyList keys
 * @property MessageList messages
 * @property NewKeyList newKeys
 * @property NewSigningKeyList newSigningKeys
 * @property NotificationList notifications
 * @property OutgoingCallerIdList outgoingCallerIds
 * @property QueueList queues
 * @property RecordingList recordings
 * @property SigningKeyList signingKeys
 * @property SipList sip
 * @property ShortCodeList shortCodes
 * @property TokenList tokens
 * @property TranscriptionList transcriptions
 * @property UsageList usage
 * @property ValidationRequestList validationRequests
 * @method AddressContext addresses(string $sid)
 * @method ApplicationContext applications(string $sid)
 * @method AuthorizedConnectAppContext authorizedConnectApps(string $connectAppSid)
 * @method AvailablePhoneNumberCountryContext availablePhoneNumbers(string $countryCode)
 * @method CallContext calls(string $sid)
 * @method ConferenceContext conferences(string $sid)
 * @method ConnectAppContext connectApps(string $sid)
 * @method IncomingPhoneNumberContext incomingPhoneNumbers(string $sid)
 * @method KeyContext keys(string $sid)
 * @method MessageContext messages(string $sid)
 * @method NotificationContext notifications(string $sid)
 * @method OutgoingCallerIdContext outgoingCallerIds(string $sid)
 * @method QueueContext queues(string $sid)
 * @method RecordingContext recordings(string $sid)
 * @method SigningKeyContext signingKeys(string $sid)
 * @method ShortCodeContext shortCodes(string $sid)
 * @method TranscriptionContext transcriptions(string $sid)
 * @method AccountContext accounts(string $sid)
 */
class Api extends Domain {
    protected $_v2010 = null;

    /**
     * Construct the Api Domain
     * 
     * @param Client $client Twilio\Rest\Client to communicate with
     *                                    Twilio
     * @return Api Domain for Api
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://api.twilio.com';
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     *
     * @return Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get($name) {
        $method = 'get' . ucfirst($name);
        if (method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $method = 'context' . ucfirst($name);
        if (method_exists($this, $method)) {
            return call_user_func_array(array($this, $method), $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Api]';
    }

    /**
     * @return V2010 Version v2010 of api
     */
    protected function getV2010() {
        if (!$this->_v2010) {
            $this->_v2010 = new V2010($this);
        }
        return $this->_v2010;
    }

    /**
     * @return AccountContext Account provided as the
     *                                               authenticating account
     */
    protected function getAccount() {
        return $this->v2010->account;
    }

    /**
     * @return AccountList
     */
    protected function getAccounts() {
        return $this->v2010->accounts;
    }

    /**
     * @param string $sid Fetch by unique Account Sid
     * @return AccountContext
     */
    protected function contextAccounts($sid) {
        return $this->v2010->accounts($sid);
    }

    /**
     * @return AddressList
     */
    protected function getAddresses() {
        return $this->v2010->account->addresses;
    }

    /**
     * @param string $sid The sid
     * @return AddressContext
     */
    protected function contextAddresses($sid) {
        return $this->v2010->account->addresses($sid);
    }

    /**
     * @return ApplicationList
     */
    protected function getApplications() {
        return $this->v2010->account->applications;
    }

    /**
     * @param string $sid Fetch by unique Application Sid
     * @return ApplicationContext
     */
    protected function contextApplications($sid) {
        return $this->v2010->account->applications($sid);
    }

    /**
     * @return AuthorizedConnectAppList
     */
    protected function getAuthorizedConnectApps() {
        return $this->v2010->account->authorizedConnectApps;
    }

    /**
     * @param string $connectAppSid The connect_app_sid
     * @return AuthorizedConnectAppContext
     */
    protected function contextAuthorizedConnectApps($connectAppSid) {
        return $this->v2010->account->authorizedConnectApps($connectAppSid);
    }

    /**
     * @return AvailablePhoneNumberCountryList
     */
    protected function getAvailablePhoneNumbers() {
        return $this->v2010->account->availablePhoneNumbers;
    }

    /**
     * @param string $countryCode The country_code
     * @return AvailablePhoneNumberCountryContext
     */
    protected function contextAvailablePhoneNumbers($countryCode) {
        return $this->v2010->account->availablePhoneNumbers($countryCode);
    }

    /**
     * @return BalanceList
     */
    protected function getBalance() {
        return $this->v2010->account->balance;
    }

    /**
     * @return CallList
     */
    protected function getCalls() {
        return $this->v2010->account->calls;
    }

    /**
     * @param string $sid Call Sid that uniquely identifies the Call to fetch
     * @return CallContext
     */
    protected function contextCalls($sid) {
        return $this->v2010->account->calls($sid);
    }

    /**
     * @return ConferenceList
     */
    protected function getConferences() {
        return $this->v2010->account->conferences;
    }

    /**
     * @param string $sid Fetch by unique conference Sid
     * @return ConferenceContext
     */
    protected function contextConferences($sid) {
        return $this->v2010->account->conferences($sid);
    }

    /**
     * @return ConnectAppList
     */
    protected function getConnectApps() {
        return $this->v2010->account->connectApps;
    }

    /**
     * @param string $sid Fetch by unique connect-app Sid
     * @return ConnectAppContext
     */
    protected function contextConnectApps($sid) {
        return $this->v2010->account->connectApps($sid);
    }

    /**
     * @return IncomingPhoneNumberList
     */
    protected function getIncomingPhoneNumbers() {
        return $this->v2010->account->incomingPhoneNumbers;
    }

    /**
     * @param string $sid Fetch by unique incoming-phone-number Sid
     * @return IncomingPhoneNumberContext
     */
    protected function contextIncomingPhoneNumbers($sid) {
        return $this->v2010->account->incomingPhoneNumbers($sid);
    }

    /**
     * @return KeyList
     */
    protected function getKeys() {
        return $this->v2010->account->keys;
    }

    /**
     * @param string $sid The sid
     * @return KeyContext
     */
    protected function contextKeys($sid) {
        return $this->v2010->account->keys($sid);
    }

    /**
     * @return MessageList
     */
    protected function getMessages() {
        return $this->v2010->account->messages;
    }

    /**
     * @param string $sid Fetch by unique message Sid
     * @return MessageContext
     */
    protected function contextMessages($sid) {
        return $this->v2010->account->messages($sid);
    }

    /**
     * @return NewKeyList
     */
    protected function getNewKeys() {
        return $this->v2010->account->newKeys;
    }

    /**
     * @return NewSigningKeyList
     */
    protected function getNewSigningKeys() {
        return $this->v2010->account->newSigningKeys;
    }

    /**
     * @return NotificationList
     */
    protected function getNotifications() {
        return $this->v2010->account->notifications;
    }

    /**
     * @param string $sid Fetch by unique notification Sid
     * @return NotificationContext
     */
    protected function contextNotifications($sid) {
        return $this->v2010->account->notifications($sid);
    }

    /**
     * @return OutgoingCallerIdList
     */
    protected function getOutgoingCallerIds() {
        return $this->v2010->account->outgoingCallerIds;
    }

    /**
     * @param string $sid Fetch by unique outgoing-caller-id Sid
     * @return OutgoingCallerIdContext
     */
    protected function contextOutgoingCallerIds($sid) {
        return $this->v2010->account->outgoingCallerIds($sid);
    }

    /**
     * @return QueueList
     */
    protected function getQueues() {
        return $this->v2010->account->queues;
    }

    /**
     * @param string $sid Fetch by unique queue Sid
     * @return QueueContext
     */
    protected function contextQueues($sid) {
        return $this->v2010->account->queues($sid);
    }

    /**
     * @return RecordingList
     */
    protected function getRecordings() {
        return $this->v2010->account->recordings;
    }

    /**
     * @param string $sid Fetch by unique recording SID
     * @return RecordingContext
     */
    protected function contextRecordings($sid) {
        return $this->v2010->account->recordings($sid);
    }

    /**
     * @return SigningKeyList
     */
    protected function getSigningKeys() {
        return $this->v2010->account->signingKeys;
    }

    /**
     * @param string $sid The sid
     * @return SigningKeyContext
     */
    protected function contextSigningKeys($sid) {
        return $this->v2010->account->signingKeys($sid);
    }

    /**
     * @return SipList
     */
    protected function getSip() {
        return $this->v2010->account->sip;
    }

    /**
     * @return ShortCodeList
     */
    protected function getShortCodes() {
        return $this->v2010->account->shortCodes;
    }

    /**
     * @param string $sid Fetch by unique short-code Sid
     * @return ShortCodeContext
     */
    protected function contextShortCodes($sid) {
        return $this->v2010->account->shortCodes($sid);
    }

    /**
     * @return TokenList
     */
    protected function getTokens() {
        return $this->v2010->account->tokens;
    }

    /**
     * @return TranscriptionList
     */
    protected function getTranscriptions() {
        return $this->v2010->account->transcriptions;
    }

    /**
     * @param string $sid Fetch by unique transcription SID
     * @return TranscriptionContext
     */
    protected function contextTranscriptions($sid) {
        return $this->v2010->account->transcriptions($sid);
    }

    /**
     * @return UsageList
     */
    protected function getUsage() {
        return $this->v2010->account->usage;
    }

    /**
     * @return ValidationRequestList
     */
    protected function getValidationRequests() {
        return $this->v2010->account->validationRequests;
    }
}